<?php
$options = [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION, PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC];
$pdo = new PDO('mysql:host=localhost;port=3306;dbname=opticore;charset=utf8mb4', 'root', 'root', $options);

$users = $pdo->query("SELECT id, email, password FROM usuarios ORDER BY id")->fetchAll();

$testPasswords = ['password', 'natanael1', '123456', 'admin', 'opticore', 'Password1', 'admin123'];

echo "=== VERIFICACION DE CONTRASEÑAS ===\n\n";
foreach ($users as $u) {
    echo "Usuario: {$u['email']}\n";
    $found = false;
    foreach ($testPasswords as $pass) {
        if (password_verify($pass, $u['password'])) {
            echo "  ✓ Contraseña: '$pass'\n";
            $found = true;
            break;
        }
    }
    if (!$found) {
        echo "  ✗ Contraseña desconocida (no es ninguna de las probadas)\n";
        echo "  Hash: {$u['password']}\n";
    }
    echo "\n";
}

// FIX: Si se pasa ?fix=1, resetear todas las contraseñas a 'password'
if (isset($_GET['fix'])) {
    $newHash = password_hash('password', PASSWORD_BCRYPT, ['cost' => 12]);
    $pdo->prepare("UPDATE usuarios SET password = ? WHERE id != 10")->execute([$newHash]);
    echo "\n✓ Contraseñas reseteadas a 'password' para todos los usuarios (excepto josuepazmino@gmail.com)\n";
    echo "Credenciales:\n";
    echo "  superadmin@opticore.com / password\n";
    echo "  admin@visionclaraoptica.cl / password\n";
    echo "  vendedor@visionclaraoptica.cl / password\n";
}
