<?php
/**
 * One-time migration runner - DELETE after use
 */
require_once dirname(__DIR__) . '/config/config.php';

$sql = file_get_contents(dirname(__DIR__) . '/database/migrations/001_new_modules_permissions.sql');

// Split by semicolons, skip comments and empty lines
$statements = array_filter(
    array_map('trim', explode(';', $sql)),
    fn($s) => !empty($s) && !str_starts_with(ltrim($s), '--')
);

$db  = db()->getPdo();
$ok  = 0;
$err = [];

foreach ($statements as $stmt) {
    $clean = trim($stmt);
    if (empty($clean) || str_starts_with($clean, '--')) continue;
    try {
        $db->exec($clean);
        $ok++;
    } catch (PDOException $e) {
        $err[] = $e->getMessage() . ' | SQL: ' . substr($clean, 0, 80);
    }
}

echo "<pre>";
echo "✅ Statements executed: $ok\n";
if ($err) {
    echo "⚠️  Errors (" . count($err) . "):\n";
    foreach ($err as $e) echo "  - $e\n";
} else {
    echo "✅ No errors.\n";
}

// Verify permissions were inserted
$perms = db()->fetchAll(
    "SELECT nombre FROM permisos WHERE modulo IN ('categorias','marcas','proveedores','formas_pago','perfil') ORDER BY nombre"
);
echo "\n=== New permissions in DB ===\n";
foreach ($perms as $p) echo "  " . $p['nombre'] . "\n";

// Verify rol_permisos for admin_empresa (rol_id=2)
$count = db()->fetchColumn(
    "SELECT COUNT(*) FROM rol_permisos rp JOIN permisos p ON rp.permiso_id = p.id WHERE rp.rol_id = 2 AND p.modulo IN ('categorias','marcas','proveedores','formas_pago')"
);
echo "\nadmin_empresa permissions for new modules: $count\n";
echo "</pre>";
