<?php /* Vista: Nueva Venta - POS */ ?>

<div class="d-flex justify-content-between align-items-center mb-3">
    <h4 class="mb-0 fw-bold"><i class="bi bi-cart-plus text-primary me-2"></i>Nueva Venta</h4>
    <a href="<?= BASE_URL ?>/ventas" class="btn btn-outline-secondary btn-sm">
        <i class="bi bi-arrow-left me-1"></i>Volver
    </a>
</div>

<form method="POST" action="<?= BASE_URL ?>/ventas" id="formVenta">
<?= csrf_field() ?>
<input type="hidden" name="items"  id="inputItems">
<input type="hidden" name="pagos"  id="inputPagos">

<div class="row g-3">
    <!-- Panel izquierdo: búsqueda y carrito -->
    <div class="col-lg-8">
        <!-- Búsqueda de producto -->
        <div class="card border-0 shadow-sm mb-3">
            <div class="card-body py-2">
                <div class="input-group">
                    <span class="input-group-text"><i class="bi bi-search"></i></span>
                    <input type="text" id="buscarProducto" class="form-control form-control-lg"
                           placeholder="Buscar producto por nombre o código..." autocomplete="off">
                </div>
                <div id="resultadosProducto" class="list-group position-absolute z-3 mt-1" style="width:calc(100% - 2rem);display:none"></div>
            </div>
        </div>

        <!-- Tabla de items -->
        <div class="card border-0 shadow-sm">
            <div class="card-header bg-transparent d-flex justify-content-between align-items-center">
                <h6 class="mb-0 fw-semibold">Detalle de Venta</h6>
                <button type="button" class="btn btn-sm btn-outline-danger" onclick="limpiarCarrito()">
                    <i class="bi bi-trash me-1"></i>Limpiar
                </button>
            </div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-sm align-middle mb-0" id="tablaItems">
                        <thead class="table-light">
                            <tr>
                                <th>Producto</th>
                                <th style="width:100px">Precio</th>
                                <th style="width:90px">Cant.</th>
                                <th style="width:80px">Desc.%</th>
                                <th style="width:110px">Subtotal</th>
                                <th style="width:40px"></th>
                            </tr>
                        </thead>
                        <tbody id="tbodyItems">
                            <tr id="filaVacia">
                                <td colspan="6" class="text-center text-muted py-4">
                                    <i class="bi bi-cart fs-3 d-block mb-2 opacity-25"></i>
                                    Busca y agrega productos
                                </td>
                            </tr>
                        </tbody>
                        <tfoot class="table-light">
                            <tr>
                                <td colspan="4" class="text-end fw-medium">Subtotal:</td>
                                <td class="fw-medium" id="totalSubtotal">$0</td>
                                <td></td>
                            </tr>
                            <tr>
                                <td colspan="3" class="text-end fw-medium">Descuento Global:</td>
                                <td>
                                    <input type="number" id="descuentoGlobal" class="form-control form-control-sm"
                                           value="0" min="0" max="100" step="0.5">
                                </td>
                                <td class="text-danger fw-medium" id="totalDescuento">-$0</td>
                                <td></td>
                            </tr>
                            <tr>
                                <td colspan="4" class="text-end fw-bold fs-6">TOTAL:</td>
                                <td class="fw-bold fs-6 text-primary" id="totalFinal">$0</td>
                                <td></td>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- Panel derecho: datos de venta -->
    <div class="col-lg-4">
        <!-- Paciente -->
        <div class="card border-0 shadow-sm mb-3">
            <div class="card-header bg-transparent"><h6 class="mb-0 fw-semibold">Paciente (opcional)</h6></div>
            <div class="card-body">
                <div class="input-group mb-2">
                    <input type="text" id="buscarPaciente" class="form-control form-control-sm"
                           placeholder="Buscar paciente..." autocomplete="off">
                    <button type="button" class="btn btn-sm btn-outline-secondary" onclick="limpiarPaciente()">
                        <i class="bi bi-x-lg"></i>
                    </button>
                </div>
                <input type="hidden" name="paciente_id" id="pacienteId">
                <div id="pacienteSugerencias" class="list-group position-absolute z-3" style="max-width:280px;display:none"></div>
                <div id="pacienteInfo" class="small text-muted d-none">
                    <i class="bi bi-person-check text-success me-1"></i>
                    <span id="pacienteNombre"></span>
                </div>
            </div>
        </div>

        <!-- Datos de venta -->
        <div class="card border-0 shadow-sm mb-3">
            <div class="card-header bg-transparent"><h6 class="mb-0 fw-semibold">Datos de Venta</h6></div>
            <div class="card-body">
                <div class="mb-2">
                    <label class="form-label fw-medium small">Sucursal</label>
                    <select name="sucursal_id" class="form-select form-select-sm">
                        <?php foreach ($sucursales as $s): ?>
                        <option value="<?= $s['id'] ?>" <?= Auth::sucursalId() == $s['id'] ? 'selected' : '' ?>>
                            <?= clean($s['nombre']) ?>
                        </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="mb-2">
                    <label class="form-label fw-medium small">Tipo Documento</label>
                    <select name="tipo_documento" class="form-select form-select-sm">
                        <?php foreach (['boleta','factura','ticket','sin_documento'] as $td): ?>
                        <option value="<?= $td ?>"><?= ucfirst(str_replace('_', ' ', $td)) ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="mb-2">
                    <label class="form-label fw-medium small">Observaciones</label>
                    <textarea name="observaciones" class="form-control form-control-sm" rows="2"></textarea>
                </div>
            </div>
        </div>

        <!-- Pagos -->
        <div class="card border-0 shadow-sm mb-3">
            <div class="card-header bg-transparent d-flex justify-content-between align-items-center">
                <h6 class="mb-0 fw-semibold">Pagos</h6>
                <button type="button" class="btn btn-sm btn-outline-success" onclick="agregarPago()">
                    <i class="bi bi-plus-lg"></i>
                </button>
            </div>
            <div class="card-body p-2" id="contenedorPagos">
                <!-- Pagos dinámicos -->
            </div>
            <div class="card-footer bg-transparent d-flex justify-content-between small">
                <span>Total pagado:</span>
                <strong id="totalPagado" class="text-success">$0</strong>
            </div>
            <div class="card-footer bg-transparent d-flex justify-content-between small">
                <span>Vuelto:</span>
                <strong id="totalVuelto" class="text-info">$0</strong>
            </div>
        </div>

        <button type="submit" class="btn btn-success w-100 btn-lg" id="btnConfirmar" disabled>
            <i class="bi bi-check-circle me-2"></i>Confirmar Venta
        </button>
    </div>
</div>
</form>

<script>
const moneda = '<?= Auth::moneda() ?>';
let items = [];
let pagos = [];

// ── Formato moneda ────────────────────────────────────────────
function fmt(n) {
    return new Intl.NumberFormat('es-CL', { style: 'currency', currency: moneda }).format(n);
}

// ── Buscar producto ───────────────────────────────────────────
let timerProd;
document.getElementById('buscarProducto').addEventListener('input', function () {
    clearTimeout(timerProd);
    const q = this.value.trim();
    const res = document.getElementById('resultadosProducto');
    if (q.length < 2) { res.style.display = 'none'; return; }
    timerProd = setTimeout(() => {
        fetch('<?= BASE_URL ?>/productos/buscar?q=' + encodeURIComponent(q))
            .then(r => r.json())
            .then(data => {
                res.innerHTML = '';
                if (!data.length) { res.style.display = 'none'; return; }
                data.forEach(p => {
                    const a = document.createElement('a');
                    a.href = '#';
                    a.className = 'list-group-item list-group-item-action d-flex justify-content-between align-items-center';
                    a.innerHTML = `<span class="small fw-medium">${p.nombre}${p.codigo ? ' <code class="text-muted">['+p.codigo+']</code>' : ''}</span>
                                   <span class="badge bg-primary">${fmt(p.precio_venta)}</span>`;
                    a.addEventListener('click', e => {
                        e.preventDefault();
                        agregarItem(p);
                        document.getElementById('buscarProducto').value = '';
                        res.style.display = 'none';
                    });
                    res.appendChild(a);
                });
                res.style.display = 'block';
            });
    }, 300);
});

document.addEventListener('click', e => {
    const res = document.getElementById('resultadosProducto');
    if (!res.contains(e.target) && e.target !== document.getElementById('buscarProducto')) {
        res.style.display = 'none';
    }
});

// ── Agregar item al carrito ───────────────────────────────────
function agregarItem(p) {
    const idx = items.findIndex(i => i.producto_id === p.id);
    if (idx >= 0) {
        items[idx].cantidad++;
    } else {
        items.push({ producto_id: p.id, nombre: p.nombre, precio: parseFloat(p.precio_venta), cantidad: 1, descuento: 0 });
    }
    renderItems();
}

function renderItems() {
    const tbody = document.getElementById('tbodyItems');
    const filaVacia = document.getElementById('filaVacia');
    tbody.innerHTML = '';

    if (!items.length) {
        tbody.appendChild(filaVacia);
        calcularTotales();
        return;
    }

    items.forEach((item, idx) => {
        const subtotal = item.precio * item.cantidad * (1 - item.descuento / 100);
        const tr = document.createElement('tr');
        tr.innerHTML = `
            <td class="small fw-medium">${item.nombre}</td>
            <td><input type="number" class="form-control form-control-sm" value="${item.precio}" min="0" step="0.01"
                       onchange="items[${idx}].precio=parseFloat(this.value)||0;renderItems()"></td>
            <td><input type="number" class="form-control form-control-sm" value="${item.cantidad}" min="1"
                       onchange="items[${idx}].cantidad=parseInt(this.value)||1;renderItems()"></td>
            <td><input type="number" class="form-control form-control-sm" value="${item.descuento}" min="0" max="100"
                       onchange="items[${idx}].descuento=parseFloat(this.value)||0;renderItems()"></td>
            <td class="small fw-medium">${fmt(subtotal)}</td>
            <td><button type="button" class="btn btn-xs btn-outline-danger" style="padding:1px 6px;font-size:11px"
                        onclick="items.splice(${idx},1);renderItems()"><i class="bi bi-x-lg"></i></button></td>`;
        tbody.appendChild(tr);
    });
    calcularTotales();
}

function calcularTotales() {
    const descGlobal = parseFloat(document.getElementById('descuentoGlobal').value) || 0;
    let subtotal = items.reduce((s, i) => s + i.precio * i.cantidad * (1 - i.descuento / 100), 0);
    const descuento = subtotal * descGlobal / 100;
    const total = subtotal - descuento;

    document.getElementById('totalSubtotal').textContent  = fmt(subtotal);
    document.getElementById('totalDescuento').textContent = '-' + fmt(descuento);
    document.getElementById('totalFinal').textContent     = fmt(total);

    document.getElementById('inputItems').value = JSON.stringify(items);
    document.getElementById('inputPagos').value = JSON.stringify(pagos);
    actualizarVuelto(total);
    validarFormulario(total);
}

document.getElementById('descuentoGlobal').addEventListener('input', calcularTotales);

function limpiarCarrito() { items = []; renderItems(); }

// ── Pagos ─────────────────────────────────────────────────────
const metodos = ['efectivo','tarjeta_debito','tarjeta_credito','transferencia','cheque'];

function agregarPago() {
    const descGlobal = parseFloat(document.getElementById('descuentoGlobal').value) || 0;
    let subtotal = items.reduce((s, i) => s + i.precio * i.cantidad * (1 - i.descuento / 100), 0);
    const total = subtotal * (1 - descGlobal / 100);
    const pagado = pagos.reduce((s, p) => s + p.monto, 0);
    const restante = Math.max(0, total - pagado);

    pagos.push({ metodo: 'efectivo', monto: restante });
    renderPagos();
}

function renderPagos() {
    const cont = document.getElementById('contenedorPagos');
    cont.innerHTML = '';
    pagos.forEach((pago, idx) => {
        const div = document.createElement('div');
        div.className = 'd-flex gap-1 mb-1 align-items-center';
        div.innerHTML = `
            <select class="form-select form-select-sm" onchange="pagos[${idx}].metodo=this.value">
                ${metodos.map(m => `<option value="${m}" ${pago.metodo===m?'selected':''}>${m.replace('_',' ')}</option>`).join('')}
            </select>
            <input type="number" class="form-control form-control-sm" value="${pago.monto}" min="0" step="0.01"
                   onchange="pagos[${idx}].monto=parseFloat(this.value)||0;renderPagos()">
            <button type="button" class="btn btn-sm btn-outline-danger" onclick="pagos.splice(${idx},1);renderPagos()">
                <i class="bi bi-x-lg"></i>
            </button>`;
        cont.appendChild(div);
    });
    calcularTotales();
}

function actualizarVuelto(total) {
    const pagado = pagos.reduce((s, p) => s + p.monto, 0);
    const vuelto = Math.max(0, pagado - total);
    document.getElementById('totalPagado').textContent = fmt(pagado);
    document.getElementById('totalVuelto').textContent = fmt(vuelto);
    document.getElementById('inputPagos').value = JSON.stringify(pagos);
}

function validarFormulario(total) {
    const btn = document.getElementById('btnConfirmar');
    const pagado = pagos.reduce((s, p) => s + p.monto, 0);
    btn.disabled = items.length === 0 || pagado < total;
}

// ── Buscar paciente ───────────────────────────────────────────
let timerPac;
document.getElementById('buscarPaciente').addEventListener('input', function () {
    clearTimeout(timerPac);
    const q = this.value.trim();
    const sugs = document.getElementById('pacienteSugerencias');
    if (q.length < 2) { sugs.style.display = 'none'; return; }
    timerPac = setTimeout(() => {
        fetch('<?= BASE_URL ?>/pacientes/buscar?q=' + encodeURIComponent(q))
            .then(r => r.json())
            .then(data => {
                sugs.innerHTML = '';
                if (!data.length) { sugs.style.display = 'none'; return; }
                data.forEach(p => {
                    const a = document.createElement('a');
                    a.href = '#';
                    a.className = 'list-group-item list-group-item-action small';
                    a.textContent = p.nombre + ' ' + p.apellido + (p.rut ? ' — ' + p.rut : '');
                    a.addEventListener('click', e => {
                        e.preventDefault();
                        document.getElementById('pacienteId').value = p.id;
                        document.getElementById('buscarPaciente').value = p.nombre + ' ' + p.apellido;
                        document.getElementById('pacienteNombre').textContent = p.nombre + ' ' + p.apellido;
                        document.getElementById('pacienteInfo').classList.remove('d-none');
                        sugs.style.display = 'none';
                    });
                    sugs.appendChild(a);
                });
                sugs.style.display = 'block';
            });
    }, 300);
});

function limpiarPaciente() {
    document.getElementById('pacienteId').value = '';
    document.getElementById('buscarPaciente').value = '';
    document.getElementById('pacienteInfo').classList.add('d-none');
}

// Inicializar con un pago en efectivo
agregarPago();
</script>
