<?php /* Vista: Usuarios */ ?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h4 class="mb-0 fw-bold"><i class="bi bi-people text-primary me-2"></i>Usuarios</h4>
    <?php if (can('usuarios.crear')): ?>
    <a href="<?= BASE_URL ?>/usuarios/create" class="btn btn-primary">
        <i class="bi bi-plus-lg me-1"></i>Nuevo Usuario
    </a>
    <?php endif; ?>
</div>

<div class="card border-0 shadow-sm">
    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table table-hover align-middle mb-0">
                <thead class="table-light">
                    <tr>
                        <th>Usuario</th>
                        <th>Email</th>
                        <th>Rol</th>
                        <th>Sucursal</th>
                        <th>Estado</th>
                        <th>Último acceso</th>
                        <th class="text-end">Acciones</th>
                    </tr>
                </thead>
                <tbody>
                <?php foreach ($usuarios as $u): ?>
                <tr>
                    <td>
                        <div class="d-flex align-items-center gap-2">
                            <?php if ($u['avatar']): ?>
                            <img src="<?= BASE_URL . '/' . $u['avatar'] ?>" width="36" height="36"
                                 class="rounded-circle object-fit-cover" alt="">
                            <?php else: ?>
                            <div class="rounded-circle bg-primary bg-opacity-10 d-flex align-items-center justify-content-center"
                                 style="width:36px;height:36px;font-size:14px;font-weight:600;color:var(--bs-primary)">
                                <?= strtoupper(substr($u['nombre'], 0, 1) . substr($u['apellido'], 0, 1)) ?>
                            </div>
                            <?php endif; ?>
                            <div>
                                <div class="fw-semibold small"><?= clean($u['nombre'] . ' ' . $u['apellido']) ?></div>
                            </div>
                        </div>
                    </td>
                    <td class="text-muted small"><?= clean($u['email']) ?></td>
                    <td><span class="badge bg-secondary"><?= clean($u['rol_nombre'] ?? '-') ?></span></td>
                    <td class="text-muted small"><?= clean($u['sucursal_nombre'] ?? 'Todas') ?></td>
                    <td><?= statusBadge($u['estado']) ?></td>
                    <td class="text-muted small"><?= $u['ultimo_login'] ? formatDateTime($u['ultimo_login']) : 'Nunca' ?></td>
                    <td class="text-end">
                        <div class="btn-group btn-group-sm">
                            <?php if (can('usuarios.editar')): ?>
                            <a href="<?= BASE_URL ?>/usuarios/<?= $u['id'] ?>/edit" class="btn btn-outline-primary">
                                <i class="bi bi-pencil"></i>
                            </a>
                            <?php endif; ?>
                            <?php if (can('usuarios.eliminar') && $u['id'] !== Auth::id()): ?>
                            <form method="POST" action="<?= BASE_URL ?>/usuarios/<?= $u['id'] ?>/delete"
                                  data-confirm="¿Desactivar usuario?">
                                <?= csrf_field() ?>
                                <button type="submit" class="btn btn-outline-danger"><i class="bi bi-person-x"></i></button>
                            </form>
                            <?php endif; ?>
                        </div>
                    </td>
                </tr>
                <?php endforeach; ?>
                <?php if (empty($usuarios)): ?>
                <tr>
                    <td colspan="7" class="text-center text-muted py-4">No hay usuarios registrados.</td>
                </tr>
                <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
