<?php /* Vista: Editar Rol + Permisos */ ?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h4 class="mb-0 fw-bold"><i class="bi bi-shield-check text-primary me-2"></i>Editar Rol: <?= clean($rol['nombre']) ?></h4>
    <a href="<?= BASE_URL ?>/roles" class="btn btn-outline-secondary btn-sm">
        <i class="bi bi-arrow-left me-1"></i>Volver
    </a>
</div>

<div class="row g-3">
    <!-- Datos del rol -->
    <div class="col-lg-4">
        <div class="card border-0 shadow-sm">
            <div class="card-header bg-transparent"><h6 class="mb-0 fw-semibold">Datos del Rol</h6></div>
            <div class="card-body">
                <form method="POST" action="<?= BASE_URL ?>/roles/<?= $rol['id'] ?>">
                    <?= csrf_field() ?>
                    <input type="hidden" name="_action" value="datos">
                    <div class="mb-3">
                        <label class="form-label fw-medium">Nombre <span class="text-danger">*</span></label>
                        <input type="text" name="nombre" class="form-control" value="<?= clean($rol['nombre']) ?>" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label fw-medium">Slug</label>
                        <input type="text" class="form-control bg-light" value="<?= clean($rol['slug']) ?>" readonly>
                        <div class="form-text">El slug no puede modificarse.</div>
                    </div>
                    <div class="mb-3">
                        <label class="form-label fw-medium">Descripción</label>
                        <textarea name="descripcion" class="form-control" rows="3"><?= clean($rol['descripcion'] ?? '') ?></textarea>
                    </div>
                    <button type="submit" class="btn btn-primary w-100">
                        <i class="bi bi-check-lg me-1"></i>Guardar Datos
                    </button>
                </form>
            </div>
        </div>
    </div>

    <!-- Permisos -->
    <div class="col-lg-8">
        <div class="card border-0 shadow-sm">
            <div class="card-header bg-transparent d-flex justify-content-between align-items-center">
                <h6 class="mb-0 fw-semibold">Permisos del Rol</h6>
                <div class="d-flex gap-2">
                    <button type="button" class="btn btn-sm btn-outline-success" onclick="toggleAll(true)">
                        <i class="bi bi-check-all me-1"></i>Todos
                    </button>
                    <button type="button" class="btn btn-sm btn-outline-danger" onclick="toggleAll(false)">
                        <i class="bi bi-x-lg me-1"></i>Ninguno
                    </button>
                </div>
            </div>
            <div class="card-body">
                <form method="POST" action="<?= BASE_URL ?>/roles/<?= $rol['id'] ?>/permisos" id="formPermisos">
                    <?= csrf_field() ?>

                    <?php foreach ($permisos as $modulo => $items): ?>
                    <div class="mb-4">
                        <div class="d-flex align-items-center gap-2 mb-2">
                            <h6 class="mb-0 text-uppercase fw-bold text-muted small"><?= clean($modulo) ?></h6>
                            <hr class="flex-fill my-0">
                            <button type="button" class="btn btn-xs btn-link text-muted p-0"
                                    onclick="toggleModulo('<?= $modulo ?>', true)" style="font-size:11px">Todo</button>
                            <span class="text-muted">|</span>
                            <button type="button" class="btn btn-xs btn-link text-muted p-0"
                                    onclick="toggleModulo('<?= $modulo ?>', false)" style="font-size:11px">Nada</button>
                        </div>
                        <div class="row g-2">
                        <?php foreach ($items as $p): ?>
                        <div class="col-md-6 col-lg-4">
                            <div class="form-check">
                                <input class="form-check-input perm-check perm-<?= $modulo ?>"
                                       type="checkbox" name="permisos[]"
                                       value="<?= $p['id'] ?>" id="perm_<?= $p['id'] ?>"
                                       <?= $p['granted'] ? 'checked' : '' ?>>
                                <label class="form-check-label small" for="perm_<?= $p['id'] ?>">
                                    <?= clean($p['nombre']) ?>
                                    <?php if ($p['descripcion']): ?>
                                    <i class="bi bi-info-circle text-muted ms-1"
                                       title="<?= clean($p['descripcion']) ?>"
                                       data-bs-toggle="tooltip"></i>
                                    <?php endif; ?>
                                </label>
                            </div>
                        </div>
                        <?php endforeach; ?>
                        </div>
                    </div>
                    <?php endforeach; ?>

                    <div class="d-flex justify-content-end mt-3">
                        <button type="submit" class="btn btn-primary px-4">
                            <i class="bi bi-shield-check me-1"></i>Guardar Permisos
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
function toggleAll(state) {
    document.querySelectorAll('.perm-check').forEach(cb => cb.checked = state);
}
function toggleModulo(modulo, state) {
    document.querySelectorAll('.perm-' + modulo).forEach(cb => cb.checked = state);
}
// Tooltips
document.querySelectorAll('[data-bs-toggle="tooltip"]').forEach(el => {
    new bootstrap.Tooltip(el);
});
</script>
