<?php /* Vista: Reportes - Índice */ ?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h4 class="mb-0 fw-bold"><i class="bi bi-bar-chart-line text-primary me-2"></i>Reportes</h4>
</div>

<div class="row g-3">
    <!-- Reporte de Ventas -->
    <div class="col-md-6 col-xl-3">
        <a href="<?= BASE_URL ?>/reportes/ventas" class="text-decoration-none">
            <div class="card border-0 shadow-sm h-100 card-hover">
                <div class="card-body text-center py-4">
                    <div class="rounded-circle bg-primary bg-opacity-10 d-inline-flex align-items-center justify-content-center mb-3"
                         style="width:64px;height:64px">
                        <i class="bi bi-receipt fs-2 text-primary"></i>
                    </div>
                    <h6 class="fw-bold mb-1">Ventas</h6>
                    <p class="text-muted small mb-0">Análisis de ventas por período, producto y vendedor.</p>
                </div>
            </div>
        </a>
    </div>

    <!-- Reporte de Stock -->
    <div class="col-md-6 col-xl-3">
        <a href="<?= BASE_URL ?>/reportes/stock" class="text-decoration-none">
            <div class="card border-0 shadow-sm h-100 card-hover">
                <div class="card-body text-center py-4">
                    <div class="rounded-circle bg-warning bg-opacity-10 d-inline-flex align-items-center justify-content-center mb-3"
                         style="width:64px;height:64px">
                        <i class="bi bi-boxes fs-2 text-warning"></i>
                    </div>
                    <h6 class="fw-bold mb-1">Stock</h6>
                    <p class="text-muted small mb-0">Inventario actual, productos bajo mínimo y movimientos.</p>
                </div>
            </div>
        </a>
    </div>

    <!-- Reporte de Caja -->
    <div class="col-md-6 col-xl-3">
        <a href="<?= BASE_URL ?>/reportes/caja" class="text-decoration-none">
            <div class="card border-0 shadow-sm h-100 card-hover">
                <div class="card-body text-center py-4">
                    <div class="rounded-circle bg-success bg-opacity-10 d-inline-flex align-items-center justify-content-center mb-3"
                         style="width:64px;height:64px">
                        <i class="bi bi-cash-register fs-2 text-success"></i>
                    </div>
                    <h6 class="fw-bold mb-1">Caja</h6>
                    <p class="text-muted small mb-0">Historial de cajas, ingresos, egresos y diferencias.</p>
                </div>
            </div>
        </a>
    </div>

    <!-- Reporte de Pacientes -->
    <div class="col-md-6 col-xl-3">
        <a href="<?= BASE_URL ?>/pacientes" class="text-decoration-none">
            <div class="card border-0 shadow-sm h-100 card-hover">
                <div class="card-body text-center py-4">
                    <div class="rounded-circle bg-info bg-opacity-10 d-inline-flex align-items-center justify-content-center mb-3"
                         style="width:64px;height:64px">
                        <i class="bi bi-people fs-2 text-info"></i>
                    </div>
                    <h6 class="fw-bold mb-1">Pacientes</h6>
                    <p class="text-muted small mb-0">Listado completo de pacientes y su historial.</p>
                </div>
            </div>
        </a>
    </div>
</div>

<!-- Resumen rápido -->
<div class="row g-3 mt-2">
    <div class="col-12">
        <h5 class="fw-semibold mb-3">Resumen del Mes</h5>
    </div>
    <div class="col-sm-6 col-xl-3">
        <div class="card border-0 shadow-sm text-center py-3">
            <div class="fs-3 fw-bold text-success"><?= formatMoney($resumen['ventas_mes'] ?? 0, Auth::moneda()) ?></div>
            <div class="text-muted small">Ventas del Mes</div>
        </div>
    </div>
    <div class="col-sm-6 col-xl-3">
        <div class="card border-0 shadow-sm text-center py-3">
            <div class="fs-3 fw-bold text-primary"><?= $resumen['cantidad_ventas_mes'] ?? 0 ?></div>
            <div class="text-muted small">N° Ventas</div>
        </div>
    </div>
    <div class="col-sm-6 col-xl-3">
        <div class="card border-0 shadow-sm text-center py-3">
            <div class="fs-3 fw-bold text-warning"><?= $resumen['productos_bajo_stock'] ?? 0 ?></div>
            <div class="text-muted small">Productos Bajo Stock</div>
        </div>
    </div>
    <div class="col-sm-6 col-xl-3">
        <div class="card border-0 shadow-sm text-center py-3">
            <div class="fs-3 fw-bold text-info"><?= $resumen['pacientes_mes'] ?? 0 ?></div>
            <div class="text-muted small">Pacientes Nuevos</div>
        </div>
    </div>
</div>

<style>
.card-hover { transition: transform .15s, box-shadow .15s; }
.card-hover:hover { transform: translateY(-3px); box-shadow: 0 .5rem 1.5rem rgba(0,0,0,.12) !important; }
</style>
