<?php /* Vista: Reporte de Caja */ ?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h4 class="mb-0 fw-bold"><i class="bi bi-cash-register text-success me-2"></i>Reporte de Caja</h4>
    <a href="<?= BASE_URL ?>/reportes" class="btn btn-outline-secondary btn-sm">
        <i class="bi bi-arrow-left me-1"></i>Reportes
    </a>
</div>

<!-- Filtros -->
<div class="card border-0 shadow-sm mb-4">
    <div class="card-body">
        <form method="GET" action="<?= BASE_URL ?>/reportes/caja" class="row g-2 align-items-end">
            <div class="col-sm-6 col-md-3">
                <label class="form-label small fw-medium">Desde</label>
                <input type="date" name="desde" class="form-control form-control-sm"
                       value="<?= clean(get('desde', date('Y-m-01'))) ?>">
            </div>
            <div class="col-sm-6 col-md-3">
                <label class="form-label small fw-medium">Hasta</label>
                <input type="date" name="hasta" class="form-control form-control-sm"
                       value="<?= clean(get('hasta', date('Y-m-d'))) ?>">
            </div>
            <div class="col-sm-6 col-md-3">
                <label class="form-label small fw-medium">Sucursal</label>
                <select name="sucursal_id" class="form-select form-select-sm">
                    <option value="">Todas</option>
                    <?php foreach ($sucursales as $s): ?>
                    <option value="<?= $s['id'] ?>" <?= get('sucursal_id') == $s['id'] ? 'selected' : '' ?>>
                        <?= clean($s['nombre']) ?>
                    </option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="col-sm-6 col-md-3 d-flex gap-2 align-items-end">
                <button type="submit" class="btn btn-primary btn-sm">
                    <i class="bi bi-search me-1"></i>Filtrar
                </button>
                <a href="<?= BASE_URL ?>/reportes/caja/export?<?= http_build_query($_GET) ?>"
                   class="btn btn-outline-success btn-sm">
                    <i class="bi bi-file-earmark-excel me-1"></i>CSV
                </a>
            </div>
        </form>
    </div>
</div>

<!-- KPIs -->
<div class="row g-3 mb-4">
    <div class="col-sm-6 col-xl-3">
        <div class="card border-0 shadow-sm text-center py-3">
            <div class="fs-3 fw-bold text-success"><?= formatMoney($kpis['total_ventas'] ?? 0, Auth::moneda()) ?></div>
            <div class="text-muted small">Total Ventas</div>
        </div>
    </div>
    <div class="col-sm-6 col-xl-3">
        <div class="card border-0 shadow-sm text-center py-3">
            <div class="fs-3 fw-bold text-primary"><?= formatMoney($kpis['total_ingresos'] ?? 0, Auth::moneda()) ?></div>
            <div class="text-muted small">Ingresos Extra</div>
        </div>
    </div>
    <div class="col-sm-6 col-xl-3">
        <div class="card border-0 shadow-sm text-center py-3">
            <div class="fs-3 fw-bold text-danger"><?= formatMoney($kpis['total_egresos'] ?? 0, Auth::moneda()) ?></div>
            <div class="text-muted small">Egresos</div>
        </div>
    </div>
    <div class="col-sm-6 col-xl-3">
        <div class="card border-0 shadow-sm text-center py-3">
            <?php $diferencia = ($kpis['total_ventas'] ?? 0) + ($kpis['total_ingresos'] ?? 0) - ($kpis['total_egresos'] ?? 0); ?>
            <div class="fs-3 fw-bold <?= $diferencia >= 0 ? 'text-info' : 'text-danger' ?>"><?= formatMoney($diferencia, Auth::moneda()) ?></div>
            <div class="text-muted small">Neto del Período</div>
        </div>
    </div>
</div>

<div class="row g-3">
    <!-- Historial de cajas -->
    <div class="col-lg-8">
        <div class="card border-0 shadow-sm">
            <div class="card-header bg-transparent d-flex justify-content-between align-items-center">
                <h6 class="mb-0 fw-semibold">Historial de Cajas</h6>
                <span class="badge bg-secondary"><?= count($cajas) ?> cajas</span>
            </div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-hover align-middle mb-0">
                        <thead class="table-light">
                            <tr>
                                <th>Apertura</th>
                                <th>Cierre</th>
                                <th>Sucursal</th>
                                <th class="text-end">S. Inicial</th>
                                <th class="text-end">Ventas</th>
                                <th class="text-end">S. Final</th>
                                <th class="text-end">Diferencia</th>
                                <th>Estado</th>
                            </tr>
                        </thead>
                        <tbody>
                        <?php foreach ($cajas as $c): ?>
                        <tr>
                            <td class="small"><?= formatDateTime($c['fecha_apertura']) ?></td>
                            <td class="small text-muted"><?= $c['fecha_cierre'] ? formatDateTime($c['fecha_cierre']) : '-' ?></td>
                            <td class="small text-muted"><?= clean($c['sucursal_nombre']) ?></td>
                            <td class="text-end small"><?= formatMoney($c['saldo_inicial'], Auth::moneda()) ?></td>
                            <td class="text-end small text-success"><?= formatMoney($c['total_ventas'] ?? 0, Auth::moneda()) ?></td>
                            <td class="text-end small fw-medium"><?= $c['saldo_final'] !== null ? formatMoney($c['saldo_final'], Auth::moneda()) : '-' ?></td>
                            <td class="text-end small <?= ($c['diferencia'] ?? 0) < 0 ? 'text-danger' : 'text-success' ?>">
                                <?= $c['diferencia'] !== null ? formatMoney($c['diferencia'], Auth::moneda()) : '-' ?>
                            </td>
                            <td><?= statusBadge($c['estado']) ?></td>
                        </tr>
                        <?php endforeach; ?>
                        <?php if (empty($cajas)): ?>
                        <tr>
                            <td colspan="8" class="text-center text-muted py-4">No hay cajas en el período seleccionado.</td>
                        </tr>
                        <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- Desglose por método de pago -->
    <div class="col-lg-4">
        <div class="card border-0 shadow-sm mb-3">
            <div class="card-header bg-transparent"><h6 class="mb-0 fw-semibold">Por Método de Pago</h6></div>
            <div class="card-body p-0">
                <table class="table table-sm mb-0">
                    <thead class="table-light">
                        <tr><th>Método</th><th class="text-center">N°</th><th class="text-end">Total</th></tr>
                    </thead>
                    <tbody>
                    <?php foreach ($porMetodo as $m): ?>
                    <tr>
                        <td class="small">
                            <i class="bi bi-<?= $m['metodo'] === 'efectivo' ? 'cash' : 'credit-card' ?> me-1 text-muted"></i>
                            <?= ucfirst(str_replace('_', ' ', $m['metodo'])) ?>
                        </td>
                        <td class="text-center small"><?= $m['cantidad'] ?></td>
                        <td class="text-end small fw-medium"><?= formatMoney($m['total'], Auth::moneda()) ?></td>
                    </tr>
                    <?php endforeach; ?>
                    <?php if (empty($porMetodo)): ?>
                    <tr><td colspan="3" class="text-center text-muted py-2 small">Sin datos.</td></tr>
                    <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>

        <!-- Diferencias acumuladas -->
        <?php if (!empty($diferencias)): ?>
        <div class="card border-0 shadow-sm">
            <div class="card-header bg-transparent"><h6 class="mb-0 fw-semibold">Diferencias de Caja</h6></div>
            <div class="card-body small">
                <div class="d-flex justify-content-between mb-1">
                    <span class="text-muted">Total sobrante:</span>
                    <span class="text-success fw-medium"><?= formatMoney($diferencias['sobrante'] ?? 0, Auth::moneda()) ?></span>
                </div>
                <div class="d-flex justify-content-between mb-1">
                    <span class="text-muted">Total faltante:</span>
                    <span class="text-danger fw-medium"><?= formatMoney($diferencias['faltante'] ?? 0, Auth::moneda()) ?></span>
                </div>
                <hr class="my-2">
                <div class="d-flex justify-content-between fw-bold">
                    <span>Neto diferencias:</span>
                    <?php $neto = ($diferencias['sobrante'] ?? 0) - ($diferencias['faltante'] ?? 0); ?>
                    <span class="<?= $neto >= 0 ? 'text-success' : 'text-danger' ?>"><?= formatMoney($neto, Auth::moneda()) ?></span>
                </div>
            </div>
        </div>
        <?php endif; ?>
    </div>
</div>
