<?php /* Vista: Nueva Receta */ ?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h4 class="mb-0 fw-bold"><i class="bi bi-eyeglasses text-primary me-2"></i>Nueva Receta</h4>
    <a href="<?= BASE_URL ?>/recetas" class="btn btn-outline-secondary btn-sm">
        <i class="bi bi-arrow-left me-1"></i>Volver
    </a>
</div>

<div class="row justify-content-center">
<div class="col-lg-10">
<div class="card border-0 shadow-sm">
<div class="card-body p-4">
<form method="POST" action="<?= BASE_URL ?>/recetas" enctype="multipart/form-data">
    <?= csrf_field() ?>
    <div class="row g-3">

        <!-- Paciente -->
        <div class="col-12"><h6 class="text-muted fw-semibold border-bottom pb-2">Paciente</h6></div>
        <div class="col-md-8">
            <label class="form-label fw-medium">Paciente <span class="text-danger">*</span></label>
            <div class="input-group">
                <input type="text" id="pacienteBuscar" class="form-control"
                       placeholder="Buscar por nombre o RUT..."
                       value="<?= clean($pacienteSeleccionado['nombre'] ?? '' . ' ' . ($pacienteSeleccionado['apellido'] ?? '')) ?>"
                       autocomplete="off">
                <button type="button" class="btn btn-outline-secondary" onclick="limpiarPaciente()">
                    <i class="bi bi-x-lg"></i>
                </button>
            </div>
            <input type="hidden" name="paciente_id" id="pacienteId"
                   value="<?= get('paciente_id') ?: post('paciente_id') ?>" required>
            <div id="pacienteSugerencias" class="list-group position-absolute z-3" style="max-width:400px;display:none"></div>
        </div>
        <div class="col-md-4">
            <label class="form-label fw-medium">Fecha <span class="text-danger">*</span></label>
            <input type="date" name="fecha" class="form-control"
                   value="<?= clean(post('fecha', date('Y-m-d'))) ?>" required>
        </div>

        <!-- Ojo Derecho -->
        <div class="col-12"><h6 class="text-muted fw-semibold border-bottom pb-2 mt-2">Ojo Derecho (OD)</h6></div>
        <div class="col-md-2">
            <label class="form-label fw-medium small">Esfera</label>
            <input type="number" name="od_esfera" class="form-control font-monospace"
                   value="<?= clean(post('od_esfera')) ?>" step="0.25" placeholder="+0.00">
        </div>
        <div class="col-md-2">
            <label class="form-label fw-medium small">Cilindro</label>
            <input type="number" name="od_cilindro" class="form-control font-monospace"
                   value="<?= clean(post('od_cilindro')) ?>" step="0.25" placeholder="-0.00">
        </div>
        <div class="col-md-2">
            <label class="form-label fw-medium small">Eje (°)</label>
            <input type="number" name="od_eje" class="form-control"
                   value="<?= clean(post('od_eje')) ?>" min="0" max="180" placeholder="0">
        </div>
        <div class="col-md-2">
            <label class="form-label fw-medium small">Adición</label>
            <input type="number" name="od_adicion" class="form-control font-monospace"
                   value="<?= clean(post('od_adicion')) ?>" step="0.25" placeholder="+0.00">
        </div>
        <div class="col-md-2">
            <label class="form-label fw-medium small">AV</label>
            <input type="text" name="od_av" class="form-control"
                   value="<?= clean(post('od_av')) ?>" placeholder="20/20">
        </div>
        <div class="col-md-2">
            <label class="form-label fw-medium small">Prisma</label>
            <input type="text" name="od_prisma" class="form-control"
                   value="<?= clean(post('od_prisma')) ?>" placeholder="0">
        </div>

        <!-- Ojo Izquierdo -->
        <div class="col-12"><h6 class="text-muted fw-semibold border-bottom pb-2 mt-2">Ojo Izquierdo (OI)</h6></div>
        <div class="col-md-2">
            <label class="form-label fw-medium small">Esfera</label>
            <input type="number" name="oi_esfera" class="form-control font-monospace"
                   value="<?= clean(post('oi_esfera')) ?>" step="0.25" placeholder="+0.00">
        </div>
        <div class="col-md-2">
            <label class="form-label fw-medium small">Cilindro</label>
            <input type="number" name="oi_cilindro" class="form-control font-monospace"
                   value="<?= clean(post('oi_cilindro')) ?>" step="0.25" placeholder="-0.00">
        </div>
        <div class="col-md-2">
            <label class="form-label fw-medium small">Eje (°)</label>
            <input type="number" name="oi_eje" class="form-control"
                   value="<?= clean(post('oi_eje')) ?>" min="0" max="180" placeholder="0">
        </div>
        <div class="col-md-2">
            <label class="form-label fw-medium small">Adición</label>
            <input type="number" name="oi_adicion" class="form-control font-monospace"
                   value="<?= clean(post('oi_adicion')) ?>" step="0.25" placeholder="+0.00">
        </div>
        <div class="col-md-2">
            <label class="form-label fw-medium small">AV</label>
            <input type="text" name="oi_av" class="form-control"
                   value="<?= clean(post('oi_av')) ?>" placeholder="20/20">
        </div>
        <div class="col-md-2">
            <label class="form-label fw-medium small">Prisma</label>
            <input type="text" name="oi_prisma" class="form-control"
                   value="<?= clean(post('oi_prisma')) ?>" placeholder="0">
        </div>

        <!-- Datos adicionales -->
        <div class="col-12"><h6 class="text-muted fw-semibold border-bottom pb-2 mt-2">Datos Adicionales</h6></div>
        <div class="col-md-3">
            <label class="form-label fw-medium small">D.P. (mm)</label>
            <input type="number" name="dp" class="form-control" value="<?= clean(post('dp')) ?>" step="0.5" placeholder="63.0">
        </div>
        <div class="col-md-3">
            <label class="form-label fw-medium small">Tipo de Lente</label>
            <select name="tipo_lente" class="form-select">
                <option value="">Seleccionar...</option>
                <?php foreach (['monofocal','bifocal','progresivo','contacto','solar'] as $t): ?>
                <option value="<?= $t ?>" <?= post('tipo_lente') === $t ? 'selected' : '' ?>><?= ucfirst($t) ?></option>
                <?php endforeach; ?>
            </select>
        </div>
        <div class="col-md-3">
            <label class="form-label fw-medium small">Uso</label>
            <select name="uso" class="form-select">
                <option value="">Seleccionar...</option>
                <?php foreach (['lejos','cerca','lejos_cerca','permanente'] as $u): ?>
                <option value="<?= $u ?>" <?= post('uso') === $u ? 'selected' : '' ?>><?= str_replace('_', '/', ucfirst($u)) ?></option>
                <?php endforeach; ?>
            </select>
        </div>
        <div class="col-md-3">
            <label class="form-label fw-medium small">Adjunto</label>
            <input type="file" name="adjunto" class="form-control form-control-sm" accept=".pdf,.jpg,.jpeg,.png">
        </div>
        <div class="col-12">
            <label class="form-label fw-medium small">Observaciones</label>
            <textarea name="observaciones" class="form-control" rows="2"><?= clean(post('observaciones')) ?></textarea>
        </div>

        <div class="col-12 d-flex gap-2 justify-content-end mt-2">
            <a href="<?= BASE_URL ?>/recetas" class="btn btn-outline-secondary">Cancelar</a>
            <button type="submit" class="btn btn-primary px-4">
                <i class="bi bi-check-lg me-1"></i>Guardar Receta
            </button>
        </div>
    </div>
</form>
</div>
</div>
</div>
</div>

<script>
let searchTimer;
const input    = document.getElementById('pacienteBuscar');
const hidden   = document.getElementById('pacienteId');
const sugs     = document.getElementById('pacienteSugerencias');

input.addEventListener('input', function () {
    clearTimeout(searchTimer);
    if (this.value.length < 2) { sugs.style.display = 'none'; return; }
    searchTimer = setTimeout(() => {
        fetch('<?= BASE_URL ?>/pacientes/buscar?q=' + encodeURIComponent(this.value))
            .then(r => r.json())
            .then(data => {
                sugs.innerHTML = '';
                if (!data.length) { sugs.style.display = 'none'; return; }
                data.forEach(p => {
                    const a = document.createElement('a');
                    a.href = '#';
                    a.className = 'list-group-item list-group-item-action small';
                    a.textContent = p.nombre + ' ' + p.apellido + (p.rut ? ' — ' + p.rut : '');
                    a.addEventListener('click', e => {
                        e.preventDefault();
                        input.value  = p.nombre + ' ' + p.apellido;
                        hidden.value = p.id;
                        sugs.style.display = 'none';
                    });
                    sugs.appendChild(a);
                });
                sugs.style.display = 'block';
            });
    }, 300);
});

document.addEventListener('click', e => {
    if (!sugs.contains(e.target) && e.target !== input) sugs.style.display = 'none';
});

function limpiarPaciente() {
    input.value  = '';
    hidden.value = '';
    sugs.style.display = 'none';
    input.focus();
}
</script>
