<?php /* Vista: Planes */ ?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h4 class="mb-0 fw-bold"><i class="bi bi-layers text-primary me-2"></i>Planes</h4>
    <a href="<?= BASE_URL ?>/planes/create" class="btn btn-primary">
        <i class="bi bi-plus-lg me-1"></i>Nuevo Plan
    </a>
</div>

<div class="row g-3">
<?php foreach ($planes as $plan): ?>
<div class="col-md-6 col-xl-4">
    <div class="card border-0 shadow-sm h-100">
        <div class="card-header bg-transparent d-flex justify-content-between align-items-center">
            <h6 class="mb-0 fw-bold"><?= clean($plan['nombre']) ?></h6>
            <?= statusBadge($plan['estado']) ?>
        </div>
        <div class="card-body">
            <?php if ($plan['descripcion']): ?>
            <p class="text-muted small mb-3"><?= clean($plan['descripcion']) ?></p>
            <?php endif; ?>

            <div class="row g-2 mb-3">
                <div class="col-6">
                    <div class="text-center p-2 bg-light rounded">
                        <div class="fw-bold text-primary"><?= formatMoney($plan['precio_mensual']) ?></div>
                        <div class="text-muted" style="font-size:11px">Mensual</div>
                    </div>
                </div>
                <div class="col-6">
                    <div class="text-center p-2 bg-light rounded">
                        <div class="fw-bold text-success"><?= formatMoney($plan['precio_anual']) ?></div>
                        <div class="text-muted" style="font-size:11px">Anual</div>
                    </div>
                </div>
            </div>

            <ul class="list-unstyled small mb-3">
                <li class="d-flex justify-content-between py-1 border-bottom">
                    <span class="text-muted"><i class="bi bi-shop me-1"></i>Sucursales</span>
                    <strong><?= $plan['max_sucursales'] ?></strong>
                </li>
                <li class="d-flex justify-content-between py-1 border-bottom">
                    <span class="text-muted"><i class="bi bi-person me-1"></i>Usuarios</span>
                    <strong><?= $plan['max_usuarios'] ?></strong>
                </li>
                <li class="d-flex justify-content-between py-1 border-bottom">
                    <span class="text-muted"><i class="bi bi-box-seam me-1"></i>Productos</span>
                    <strong><?= $plan['max_productos'] ?></strong>
                </li>
                <li class="d-flex justify-content-between py-1 border-bottom">
                    <span class="text-muted"><i class="bi bi-people me-1"></i>Pacientes</span>
                    <strong><?= $plan['max_pacientes'] ?></strong>
                </li>
                <li class="d-flex justify-content-between py-1">
                    <span class="text-muted"><i class="bi bi-building me-1"></i>Empresas</span>
                    <strong><?= $plan['total_empresas'] ?></strong>
                </li>
            </ul>

            <div class="d-flex gap-1 flex-wrap">
                <?php if ($plan['tiene_laboratorio']): ?>
                <span class="badge bg-info bg-opacity-10 text-info border border-info border-opacity-25">
                    <i class="bi bi-eyeglasses me-1"></i>Laboratorio
                </span>
                <?php endif; ?>
                <?php if ($plan['tiene_agenda']): ?>
                <span class="badge bg-success bg-opacity-10 text-success border border-success border-opacity-25">
                    <i class="bi bi-calendar me-1"></i>Agenda
                </span>
                <?php endif; ?>
                <?php if ($plan['tiene_reportes']): ?>
                <span class="badge bg-primary bg-opacity-10 text-primary border border-primary border-opacity-25">
                    <i class="bi bi-bar-chart me-1"></i>Reportes
                </span>
                <?php endif; ?>
                <?php if ($plan['tiene_api']): ?>
                <span class="badge bg-warning bg-opacity-10 text-warning border border-warning border-opacity-25">
                    <i class="bi bi-code-slash me-1"></i>API
                </span>
                <?php endif; ?>
            </div>
        </div>
        <div class="card-footer bg-transparent d-flex gap-2">
            <a href="<?= BASE_URL ?>/planes/<?= $plan['id'] ?>/edit" class="btn btn-sm btn-outline-primary flex-fill">
                <i class="bi bi-pencil me-1"></i>Editar
            </a>
            <?php if ($plan['total_empresas'] == 0): ?>
            <form method="POST" action="<?= BASE_URL ?>/planes/<?= $plan['id'] ?>/delete"
                  data-confirm="¿Eliminar este plan?">
                <?= csrf_field() ?>
                <button type="submit" class="btn btn-sm btn-outline-danger">
                    <i class="bi bi-trash"></i>
                </button>
            </form>
            <?php endif; ?>
        </div>
    </div>
</div>
<?php endforeach; ?>

<?php if (empty($planes)): ?>
<div class="col-12">
    <div class="text-center py-5 text-muted">
        <i class="bi bi-layers fs-1 d-block mb-3 opacity-25"></i>
        <p>No hay planes registrados.</p>
        <a href="<?= BASE_URL ?>/planes/create" class="btn btn-primary">Crear primer plan</a>
    </div>
</div>
<?php endif; ?>
</div>
