<?php /* Vista: Editar Plan */ ?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h4 class="mb-0 fw-bold"><i class="bi bi-pencil text-primary me-2"></i>Editar Plan</h4>
    <a href="<?= BASE_URL ?>/planes" class="btn btn-outline-secondary btn-sm">
        <i class="bi bi-arrow-left me-1"></i>Volver
    </a>
</div>

<div class="row justify-content-center">
<div class="col-lg-8">
<div class="card border-0 shadow-sm">
<div class="card-body p-4">
<form method="POST" action="<?= BASE_URL ?>/planes/<?= $plan['id'] ?>">
    <?= csrf_field() ?>

    <div class="row g-3">
        <div class="col-12">
            <label class="form-label fw-medium">Nombre del Plan <span class="text-danger">*</span></label>
            <input type="text" name="nombre" class="form-control" value="<?= clean($plan['nombre']) ?>" required autofocus>
        </div>

        <div class="col-12">
            <label class="form-label fw-medium">Descripción</label>
            <textarea name="descripcion" class="form-control" rows="2"><?= clean($plan['descripcion'] ?? '') ?></textarea>
        </div>

        <div class="col-md-6">
            <label class="form-label fw-medium">Precio Mensual <span class="text-danger">*</span></label>
            <div class="input-group">
                <span class="input-group-text">$</span>
                <input type="number" name="precio_mensual" class="form-control" value="<?= $plan['precio_mensual'] ?>" min="0" step="0.01" required>
            </div>
        </div>
        <div class="col-md-6">
            <label class="form-label fw-medium">Precio Anual</label>
            <div class="input-group">
                <span class="input-group-text">$</span>
                <input type="number" name="precio_anual" class="form-control" value="<?= $plan['precio_anual'] ?>" min="0" step="0.01">
            </div>
        </div>

        <div class="col-12"><hr class="my-1"><h6 class="text-muted fw-semibold">Límites del Plan</h6></div>

        <div class="col-md-3">
            <label class="form-label fw-medium">Sucursales</label>
            <input type="number" name="max_sucursales" class="form-control" value="<?= $plan['max_sucursales'] ?>" min="1">
        </div>
        <div class="col-md-3">
            <label class="form-label fw-medium">Usuarios</label>
            <input type="number" name="max_usuarios" class="form-control" value="<?= $plan['max_usuarios'] ?>" min="1">
        </div>
        <div class="col-md-3">
            <label class="form-label fw-medium">Productos</label>
            <input type="number" name="max_productos" class="form-control" value="<?= $plan['max_productos'] ?>" min="1">
        </div>
        <div class="col-md-3">
            <label class="form-label fw-medium">Pacientes</label>
            <input type="number" name="max_pacientes" class="form-control" value="<?= $plan['max_pacientes'] ?>" min="1">
        </div>

        <div class="col-12"><hr class="my-1"><h6 class="text-muted fw-semibold">Funcionalidades</h6></div>

        <div class="col-md-3">
            <div class="form-check form-switch">
                <input class="form-check-input" type="checkbox" name="tiene_laboratorio" id="laboratorio"
                       <?= $plan['tiene_laboratorio'] ? 'checked' : '' ?>>
                <label class="form-check-label" for="laboratorio">Laboratorio</label>
            </div>
        </div>
        <div class="col-md-3">
            <div class="form-check form-switch">
                <input class="form-check-input" type="checkbox" name="tiene_agenda" id="agenda"
                       <?= $plan['tiene_agenda'] ? 'checked' : '' ?>>
                <label class="form-check-label" for="agenda">Agenda</label>
            </div>
        </div>
        <div class="col-md-3">
            <div class="form-check form-switch">
                <input class="form-check-input" type="checkbox" name="tiene_reportes" id="reportes"
                       <?= $plan['tiene_reportes'] ? 'checked' : '' ?>>
                <label class="form-check-label" for="reportes">Reportes</label>
            </div>
        </div>
        <div class="col-md-3">
            <div class="form-check form-switch">
                <input class="form-check-input" type="checkbox" name="tiene_api" id="api"
                       <?= $plan['tiene_api'] ? 'checked' : '' ?>>
                <label class="form-check-label" for="api">API</label>
            </div>
        </div>

        <div class="col-md-4">
            <label class="form-label fw-medium">Estado</label>
            <select name="estado" class="form-select">
                <option value="activo"   <?= $plan['estado'] === 'activo'   ? 'selected' : '' ?>>Activo</option>
                <option value="inactivo" <?= $plan['estado'] === 'inactivo' ? 'selected' : '' ?>>Inactivo</option>
            </select>
        </div>

        <div class="col-12 d-flex gap-2 justify-content-end mt-2">
            <a href="<?= BASE_URL ?>/planes" class="btn btn-outline-secondary">Cancelar</a>
            <button type="submit" class="btn btn-primary px-4">
                <i class="bi bi-check-lg me-1"></i>Actualizar Plan
            </button>
        </div>
    </div>
</form>
</div>
</div>
</div>
</div>
