<?php /* Vista: Editar Paciente */ ?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h4 class="mb-0 fw-bold"><i class="bi bi-pencil text-primary me-2"></i>Editar Paciente</h4>
    <div class="d-flex gap-2">
        <a href="<?= BASE_URL ?>/pacientes/<?= $paciente['id'] ?>" class="btn btn-outline-secondary btn-sm">
            <i class="bi bi-eye me-1"></i>Ver
        </a>
        <a href="<?= BASE_URL ?>/pacientes" class="btn btn-outline-secondary btn-sm">
            <i class="bi bi-arrow-left me-1"></i>Volver
        </a>
    </div>
</div>

<div class="row justify-content-center">
<div class="col-lg-9">
<div class="card border-0 shadow-sm">
<div class="card-body p-4">
<form method="POST" action="<?= BASE_URL ?>/pacientes/<?= $paciente['id'] ?>">
    <?= csrf_field() ?>
    <div class="row g-3">
        <div class="col-12"><h6 class="text-muted fw-semibold border-bottom pb-2">Datos Personales</h6></div>

        <div class="col-md-5">
            <label class="form-label fw-medium">Nombre <span class="text-danger">*</span></label>
            <input type="text" name="nombre" class="form-control" value="<?= clean($paciente['nombre']) ?>" required>
        </div>
        <div class="col-md-5">
            <label class="form-label fw-medium">Apellido <span class="text-danger">*</span></label>
            <input type="text" name="apellido" class="form-control" value="<?= clean($paciente['apellido']) ?>" required>
        </div>
        <div class="col-md-2">
            <label class="form-label fw-medium">Sexo</label>
            <select name="sexo" class="form-select">
                <option value="">-</option>
                <option value="M" <?= $paciente['sexo'] === 'M' ? 'selected' : '' ?>>Masculino</option>
                <option value="F" <?= $paciente['sexo'] === 'F' ? 'selected' : '' ?>>Femenino</option>
                <option value="O" <?= $paciente['sexo'] === 'O' ? 'selected' : '' ?>>Otro</option>
            </select>
        </div>

        <div class="col-md-4">
            <label class="form-label fw-medium">RUT / Documento</label>
            <input type="text" name="rut" class="form-control" value="<?= clean($paciente['rut'] ?? '') ?>">
        </div>
        <div class="col-md-4">
            <label class="form-label fw-medium">Fecha de Nacimiento</label>
            <input type="date" name="fecha_nacimiento" class="form-control" value="<?= clean($paciente['fecha_nacimiento'] ?? '') ?>">
        </div>
        <div class="col-md-4">
            <label class="form-label fw-medium">Ocupación</label>
            <input type="text" name="ocupacion" class="form-control" value="<?= clean($paciente['ocupacion'] ?? '') ?>">
        </div>

        <div class="col-12"><h6 class="text-muted fw-semibold border-bottom pb-2 mt-2">Contacto</h6></div>

        <div class="col-md-4">
            <label class="form-label fw-medium">Teléfono</label>
            <input type="text" name="telefono" class="form-control" value="<?= clean($paciente['telefono'] ?? '') ?>">
        </div>
        <div class="col-md-4">
            <label class="form-label fw-medium">Teléfono 2</label>
            <input type="text" name="telefono2" class="form-control" value="<?= clean($paciente['telefono2'] ?? '') ?>">
        </div>
        <div class="col-md-4">
            <label class="form-label fw-medium">Email</label>
            <input type="email" name="email" class="form-control" value="<?= clean($paciente['email'] ?? '') ?>">
        </div>
        <div class="col-12">
            <label class="form-label fw-medium">Dirección</label>
            <input type="text" name="direccion" class="form-control" value="<?= clean($paciente['direccion'] ?? '') ?>">
        </div>

        <div class="col-12"><h6 class="text-muted fw-semibold border-bottom pb-2 mt-2">Información Médica</h6></div>

        <div class="col-md-6">
            <label class="form-label fw-medium">Previsión / Seguro</label>
            <input type="text" name="prevision" class="form-control" value="<?= clean($paciente['prevision'] ?? '') ?>">
        </div>
        <div class="col-md-6">
            <label class="form-label fw-medium">Médico Derivante</label>
            <input type="text" name="medico_derivante" class="form-control" value="<?= clean($paciente['medico_derivante'] ?? '') ?>">
        </div>
        <div class="col-12">
            <label class="form-label fw-medium">Antecedentes / Alergias</label>
            <textarea name="antecedentes" class="form-control" rows="2"><?= clean($paciente['antecedentes'] ?? '') ?></textarea>
        </div>
        <div class="col-12">
            <label class="form-label fw-medium">Observaciones</label>
            <textarea name="observaciones" class="form-control" rows="2"><?= clean($paciente['observaciones'] ?? '') ?></textarea>
        </div>

        <div class="col-12 d-flex gap-2 justify-content-end mt-2">
            <a href="<?= BASE_URL ?>/pacientes" class="btn btn-outline-secondary">Cancelar</a>
            <button type="submit" class="btn btn-primary px-4">
                <i class="bi bi-check-lg me-1"></i>Actualizar Paciente
            </button>
        </div>
    </div>
</form>
</div>
</div>
</div>
</div>
