<?php /* Vista: Licencias */ ?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h4 class="mb-0 fw-bold"><i class="bi bi-key text-primary me-2"></i>Licencias</h4>
    <a href="<?= BASE_URL ?>/licencias/create" class="btn btn-primary">
        <i class="bi bi-plus-lg me-1"></i>Nueva Licencia
    </a>
</div>

<!-- Estadísticas -->
<div class="row g-3 mb-4">
    <div class="col-sm-6 col-xl-3">
        <div class="card border-0 shadow-sm text-center py-3">
            <div class="fs-2 fw-bold text-success"><?= $estadisticas['activas'] ?? 0 ?></div>
            <div class="text-muted small">Activas</div>
        </div>
    </div>
    <div class="col-sm-6 col-xl-3">
        <div class="card border-0 shadow-sm text-center py-3">
            <div class="fs-2 fw-bold text-warning"><?= $estadisticas['suspendidas'] ?? 0 ?></div>
            <div class="text-muted small">Suspendidas</div>
        </div>
    </div>
    <div class="col-sm-6 col-xl-3">
        <div class="card border-0 shadow-sm text-center py-3">
            <div class="fs-2 fw-bold text-danger"><?= $estadisticas['expiradas'] ?? 0 ?></div>
            <div class="text-muted small">Expiradas</div>
        </div>
    </div>
    <div class="col-sm-6 col-xl-3">
        <div class="card border-0 shadow-sm text-center py-3">
            <div class="fs-2 fw-bold text-primary"><?= formatMoney($estadisticas['ingresos_totales'] ?? 0) ?></div>
            <div class="text-muted small">Ingresos Totales</div>
        </div>
    </div>
</div>

<!-- Alertas por vencer -->
<?php if (!empty($por_vencer)): ?>
<div class="alert alert-warning d-flex align-items-start gap-2 mb-4">
    <i class="bi bi-exclamation-triangle-fill fs-5 mt-1"></i>
    <div>
        <strong><?= count($por_vencer) ?> licencia(s) vencen en los próximos 7 días:</strong>
        <ul class="mb-0 mt-1">
        <?php foreach ($por_vencer as $l): ?>
            <li><?= clean($l['empresa_nombre']) ?> — vence el <?= formatDate($l['fecha_fin']) ?>
                (<strong><?= $l['dias_restantes'] ?> días</strong>)
            </li>
        <?php endforeach; ?>
        </ul>
    </div>
</div>
<?php endif; ?>

<!-- Tabla -->
<div class="card border-0 shadow-sm">
    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table table-hover align-middle mb-0">
                <thead class="table-light">
                    <tr>
                        <th>Empresa</th>
                        <th>Plan</th>
                        <th>Tipo</th>
                        <th>Inicio</th>
                        <th>Vencimiento</th>
                        <th>Monto</th>
                        <th>Estado</th>
                        <th class="text-end">Acciones</th>
                    </tr>
                </thead>
                <tbody>
                <?php foreach ($licencias as $l): ?>
                <tr>
                    <td class="fw-medium small"><?= clean($l['empresa_nombre']) ?></td>
                    <td><span class="badge bg-secondary"><?= clean($l['plan_nombre']) ?></span></td>
                    <td><span class="badge bg-info bg-opacity-10 text-info border border-info border-opacity-25"><?= $l['tipo'] ?></span></td>
                    <td class="text-muted small"><?= formatDate($l['fecha_inicio']) ?></td>
                    <td class="small">
                        <?php if ($l['fecha_fin']): ?>
                            <?php
                            $dias = (int) ((strtotime($l['fecha_fin']) - time()) / 86400);
                            $color = $dias <= 7 ? 'danger' : ($dias <= 30 ? 'warning' : 'muted');
                            ?>
                            <span class="text-<?= $color ?>"><?= formatDate($l['fecha_fin']) ?></span>
                            <?php if ($l['estado'] === 'activa' && $dias >= 0): ?>
                            <span class="badge bg-<?= $color ?> ms-1"><?= $dias ?>d</span>
                            <?php endif; ?>
                        <?php else: ?>
                            <span class="text-muted">Perpetua</span>
                        <?php endif; ?>
                    </td>
                    <td class="small"><?= formatMoney($l['monto']) ?></td>
                    <td><?= statusBadge($l['estado']) ?></td>
                    <td class="text-end">
                        <?php if ($l['estado'] === 'activa'): ?>
                        <form method="POST" action="<?= BASE_URL ?>/licencias/<?= $l['id'] ?>/suspender"
                              class="d-inline" data-confirm="¿Suspender esta licencia?">
                            <?= csrf_field() ?>
                            <button class="btn btn-sm btn-outline-warning">Suspender</button>
                        </form>
                        <?php elseif ($l['estado'] === 'suspendida'): ?>
                        <form method="POST" action="<?= BASE_URL ?>/licencias/<?= $l['id'] ?>/cancelar"
                              class="d-inline" data-confirm="¿Cancelar esta licencia?">
                            <?= csrf_field() ?>
                            <button class="btn btn-sm btn-outline-danger">Cancelar</button>
                        </form>
                        <?php endif; ?>
                    </td>
                </tr>
                <?php endforeach; ?>
                <?php if (empty($licencias)): ?>
                <tr>
                    <td colspan="8" class="text-center text-muted py-4">No hay licencias registradas.</td>
                </tr>
                <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
