<?php /* Vista: Nueva Licencia */ ?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h4 class="mb-0 fw-bold"><i class="bi bi-key text-primary me-2"></i>Nueva Licencia</h4>
    <a href="<?= BASE_URL ?>/licencias" class="btn btn-outline-secondary btn-sm">
        <i class="bi bi-arrow-left me-1"></i>Volver
    </a>
</div>

<div class="row justify-content-center">
<div class="col-lg-7">
<div class="card border-0 shadow-sm">
<div class="card-body p-4">
<form method="POST" action="<?= BASE_URL ?>/licencias">
    <?= csrf_field() ?>

    <div class="row g-3">
        <div class="col-12">
            <label class="form-label fw-medium">Empresa <span class="text-danger">*</span></label>
            <select name="empresa_id" class="form-select" required id="selectEmpresa">
                <option value="">Seleccionar empresa...</option>
                <?php foreach ($empresas as $e): ?>
                <option value="<?= $e['id'] ?>"
                    <?= (post('empresa_id') == $e['id'] || (get('empresa_id') == $e['id'])) ? 'selected' : '' ?>>
                    <?= clean($e['nombre']) ?>
                </option>
                <?php endforeach; ?>
            </select>
        </div>

        <div class="col-md-8">
            <label class="form-label fw-medium">Plan <span class="text-danger">*</span></label>
            <select name="plan_id" class="form-select" required>
                <option value="">Seleccionar plan...</option>
                <?php foreach ($planes as $p): ?>
                <option value="<?= $p['id'] ?>" <?= post('plan_id') == $p['id'] ? 'selected' : '' ?>
                        data-mensual="<?= $p['precio_mensual'] ?>" data-anual="<?= $p['precio_anual'] ?>">
                    <?= clean($p['nombre']) ?> — <?= formatMoney($p['precio_mensual']) ?>/mes
                </option>
                <?php endforeach; ?>
            </select>
        </div>

        <div class="col-md-4">
            <label class="form-label fw-medium">Tipo <span class="text-danger">*</span></label>
            <select name="tipo" class="form-select" required id="selectTipo">
                <?php foreach (['mensual','anual','perpetua','prueba'] as $t): ?>
                <option value="<?= $t ?>" <?= post('tipo', 'mensual') === $t ? 'selected' : '' ?>>
                    <?= ucfirst($t) ?>
                </option>
                <?php endforeach; ?>
            </select>
        </div>

        <div class="col-md-6">
            <label class="form-label fw-medium">Fecha Inicio <span class="text-danger">*</span></label>
            <input type="date" name="fecha_inicio" class="form-control"
                   value="<?= clean(post('fecha_inicio', date('Y-m-d'))) ?>" required id="fechaInicio">
        </div>

        <div class="col-md-6">
            <label class="form-label fw-medium">Fecha Fin</label>
            <input type="date" name="fecha_fin" class="form-control"
                   value="<?= clean(post('fecha_fin')) ?>" id="fechaFin">
            <div class="form-text">Dejar vacío para calcular automáticamente según el tipo.</div>
        </div>

        <div class="col-md-6">
            <label class="form-label fw-medium">Monto</label>
            <div class="input-group">
                <span class="input-group-text">$</span>
                <input type="number" name="monto" class="form-control" id="inputMonto"
                       value="<?= clean(post('monto', '0')) ?>" min="0" step="0.01">
            </div>
        </div>

        <div class="col-md-6">
            <label class="form-label fw-medium">Estado</label>
            <select name="estado" class="form-select">
                <option value="activa"     <?= post('estado', 'activa') === 'activa'     ? 'selected' : '' ?>>Activa</option>
                <option value="suspendida" <?= post('estado') === 'suspendida' ? 'selected' : '' ?>>Suspendida</option>
            </select>
        </div>

        <div class="col-12">
            <label class="form-label fw-medium">Observaciones</label>
            <textarea name="observaciones" class="form-control" rows="2"><?= clean(post('observaciones')) ?></textarea>
        </div>

        <div class="col-12 d-flex gap-2 justify-content-end mt-2">
            <a href="<?= BASE_URL ?>/licencias" class="btn btn-outline-secondary">Cancelar</a>
            <button type="submit" class="btn btn-primary px-4">
                <i class="bi bi-check-lg me-1"></i>Crear Licencia
            </button>
        </div>
    </div>
</form>
</div>
</div>
</div>
</div>

<script>
// Auto-calcular fecha fin y monto según tipo y plan
const selectTipo  = document.getElementById('selectTipo');
const fechaInicio = document.getElementById('fechaInicio');
const fechaFin    = document.getElementById('fechaFin');
const selectPlan  = document.querySelector('[name="plan_id"]');
const inputMonto  = document.getElementById('inputMonto');

function calcularFechaFin() {
    const inicio = fechaInicio.value;
    if (!inicio || fechaFin.value) return;
    const d = new Date(inicio);
    const tipo = selectTipo.value;
    if (tipo === 'mensual')  d.setMonth(d.getMonth() + 1);
    if (tipo === 'anual')    d.setFullYear(d.getFullYear() + 1);
    if (tipo === 'prueba')   d.setDate(d.getDate() + 30);
    if (tipo !== 'perpetua') fechaFin.value = d.toISOString().split('T')[0];
}

function calcularMonto() {
    const opt  = selectPlan.options[selectPlan.selectedIndex];
    const tipo = selectTipo.value;
    if (!opt || !opt.dataset.mensual) return;
    if (tipo === 'mensual') inputMonto.value = opt.dataset.mensual;
    if (tipo === 'anual')   inputMonto.value = opt.dataset.anual;
    if (tipo === 'prueba')  inputMonto.value = 0;
}

selectTipo.addEventListener('change', () => { fechaFin.value = ''; calcularFechaFin(); calcularMonto(); });
fechaInicio.addEventListener('change', calcularFechaFin);
selectPlan.addEventListener('change', calcularMonto);
</script>
