<?php /* Vista: Editar Forma de Pago */ ?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h4 class="mb-0 fw-bold"><i class="bi bi-credit-card text-primary me-2"></i>Editar Forma de Pago</h4>
    <a href="<?= BASE_URL ?>/formas-pago" class="btn btn-outline-secondary btn-sm">
        <i class="bi bi-arrow-left me-1"></i>Volver
    </a>
</div>

<div class="row justify-content-center">
<div class="col-lg-6">
<div class="card border-0 shadow-sm">
<div class="card-body p-4">
<form method="POST" action="<?= BASE_URL ?>/formas-pago/<?= $forma_pago['id'] ?>">
    <?= csrf_field() ?>
    <div class="row g-3">
        <div class="col-md-8">
            <label class="form-label fw-medium">Nombre <span class="text-danger">*</span></label>
            <input type="text" name="nombre" class="form-control"
                   value="<?= clean($forma_pago['nombre']) ?>" required autofocus>
        </div>
        <div class="col-md-4">
            <label class="form-label fw-medium">Tipo <span class="text-danger">*</span></label>
            <select name="tipo" class="form-select" required>
                <option value="">Seleccionar...</option>
                <option value="efectivo"        <?= $forma_pago['tipo'] === 'efectivo'        ? 'selected' : '' ?>>Efectivo</option>
                <option value="tarjeta_debito"  <?= $forma_pago['tipo'] === 'tarjeta_debito'  ? 'selected' : '' ?>>Tarjeta Débito</option>
                <option value="tarjeta_credito" <?= $forma_pago['tipo'] === 'tarjeta_credito' ? 'selected' : '' ?>>Tarjeta Crédito</option>
                <option value="transferencia"   <?= $forma_pago['tipo'] === 'transferencia'   ? 'selected' : '' ?>>Transferencia</option>
                <option value="cheque"          <?= $forma_pago['tipo'] === 'cheque'          ? 'selected' : '' ?>>Cheque</option>
                <option value="otro"            <?= $forma_pago['tipo'] === 'otro'            ? 'selected' : '' ?>>Otro</option>
            </select>
        </div>
        <div class="col-12">
            <label class="form-label fw-medium">Descripción</label>
            <textarea name="descripcion" class="form-control" rows="2"><?= clean($forma_pago['descripcion'] ?? '') ?></textarea>
        </div>
        <div class="col-md-6">
            <div class="form-check form-switch mt-2">
                <input class="form-check-input" type="checkbox" name="requiere_referencia" value="1"
                       id="requiereRef" <?= !empty($forma_pago['requiere_referencia']) ? 'checked' : '' ?>>
                <label class="form-check-label fw-medium" for="requiereRef">
                    Requiere número de referencia
                </label>
                <div class="form-text">Ej: número de transferencia, voucher, etc.</div>
            </div>
        </div>
        <div class="col-md-6">
            <label class="form-label fw-medium">Estado</label>
            <select name="estado" class="form-select">
                <option value="activa"   <?= $forma_pago['estado'] === 'activa'   ? 'selected' : '' ?>>Activa</option>
                <option value="inactiva" <?= $forma_pago['estado'] === 'inactiva' ? 'selected' : '' ?>>Inactiva</option>
            </select>
        </div>
        <div class="col-12 d-flex gap-2 justify-content-end mt-2">
            <a href="<?= BASE_URL ?>/formas-pago" class="btn btn-outline-secondary">Cancelar</a>
            <button type="submit" class="btn btn-primary px-4">
                <i class="bi bi-check-lg me-1"></i>Guardar Cambios
            </button>
        </div>
    </div>
</form>
</div>
</div>
</div>
</div>
