<?php /* Vista: Login */ ?>

<div class="card shadow-sm border-0">
    <div class="card-body p-4">
        <h5 class="card-title fw-semibold mb-4 text-center">Iniciar Sesión</h5>

        <form method="POST" action="<?= BASE_URL ?>/login" novalidate>
            <?= csrf_field() ?>

            <!-- Email -->
            <div class="mb-3">
                <label for="email" class="form-label fw-medium">
                    <i class="bi bi-envelope me-1"></i>Email
                </label>
                <input type="email"
                       class="form-control form-control-lg"
                       id="email"
                       name="email"
                       value="<?= clean(post('email')) ?>"
                       placeholder="usuario@empresa.com"
                       required
                       autofocus>
            </div>

            <!-- Contraseña -->
            <div class="mb-4">
                <label for="password" class="form-label fw-medium">
                    <i class="bi bi-lock me-1"></i>Contraseña
                </label>
                <div class="input-group">
                    <input type="password"
                           class="form-control form-control-lg"
                           id="password"
                           name="password"
                           placeholder="••••••••"
                           required>
                    <button class="btn btn-outline-secondary" type="button" id="togglePassword" tabindex="-1">
                        <i class="bi bi-eye" id="toggleIcon"></i>
                    </button>
                </div>
            </div>

            <!-- Submit -->
            <div class="d-grid mb-3">
                <button type="submit" class="btn btn-primary btn-lg fw-semibold">
                    <i class="bi bi-box-arrow-in-right me-2"></i>Ingresar
                </button>
            </div>

            <div class="text-center">
                <a href="<?= BASE_URL ?>/forgot-password" class="text-muted small text-decoration-none">
                    <i class="bi bi-key me-1"></i>¿Olvidaste tu contraseña?
                </a>
            </div>
        </form>
    </div>
</div>

<script>
document.getElementById('togglePassword').addEventListener('click', function () {
    const pwd  = document.getElementById('password');
    const icon = document.getElementById('toggleIcon');
    if (pwd.type === 'password') {
        pwd.type = 'text';
        icon.classList.replace('bi-eye', 'bi-eye-slash');
    } else {
        pwd.type = 'password';
        icon.classList.replace('bi-eye-slash', 'bi-eye');
    }
});
</script>
