<?php /* Vista: Editar Cita */ ?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h4 class="mb-0 fw-bold"><i class="bi bi-calendar-event text-primary me-2"></i>Editar Cita</h4>
    <a href="<?= BASE_URL ?>/agenda" class="btn btn-outline-secondary btn-sm">
        <i class="bi bi-arrow-left me-1"></i>Volver
    </a>
</div>

<div class="row justify-content-center">
<div class="col-lg-7">
<div class="card border-0 shadow-sm">
<div class="card-body p-4">
<form method="POST" action="<?= BASE_URL ?>/agenda/<?= $cita['id'] ?>">
    <?= csrf_field() ?>
    <div class="row g-3">

        <!-- Fecha y hora -->
        <div class="col-md-6">
            <label class="form-label fw-medium">Fecha <span class="text-danger">*</span></label>
            <input type="date" name="fecha" class="form-control"
                   value="<?= clean($cita['fecha']) ?>" required>
        </div>
        <div class="col-md-6">
            <label class="form-label fw-medium">Hora <span class="text-danger">*</span></label>
            <input type="time" name="hora" class="form-control"
                   value="<?= clean(substr($cita['hora'], 0, 5)) ?>" required>
        </div>

        <!-- Paciente -->
        <div class="col-12">
            <label class="form-label fw-medium">Nombre del Paciente <span class="text-danger">*</span></label>
            <input type="text" name="nombre_paciente" class="form-control" autofocus
                   value="<?= clean($cita['nombre_paciente'] ?? $cita['paciente_nombre'] ?? '') ?>"
                   placeholder="Nombre completo del paciente...">
        </div>

        <!-- Teléfono -->
        <div class="col-md-6">
            <label class="form-label fw-medium">Teléfono de Contacto</label>
            <input type="text" name="telefono_paciente" class="form-control"
                   value="<?= clean($cita['telefono_paciente'] ?? '') ?>">
        </div>

        <!-- Profesional -->
        <div class="col-md-6">
            <label class="form-label fw-medium">Profesional / Optómetra</label>
            <input type="text" name="profesional" class="form-control"
                   value="<?= clean($cita['profesional'] ?? '') ?>">
        </div>

        <!-- Motivo -->
        <div class="col-12">
            <label class="form-label fw-medium">Motivo de la Consulta</label>
            <input type="text" name="motivo" class="form-control"
                   value="<?= clean($cita['motivo'] ?? '') ?>">
        </div>

        <!-- Duración -->
        <div class="col-md-4">
            <label class="form-label fw-medium">Duración (minutos)</label>
            <select name="duracion" class="form-select">
                <?php foreach ([15, 30, 45, 60, 90, 120] as $min): ?>
                <option value="<?= $min ?>" <?= ($cita['duracion'] ?? 30) == $min ? 'selected' : '' ?>>
                    <?= $min ?> min
                </option>
                <?php endforeach; ?>
            </select>
        </div>

        <!-- Estado -->
        <div class="col-md-4">
            <label class="form-label fw-medium">Estado</label>
            <select name="estado" class="form-select">
                <option value="pendiente"   <?= $cita['estado'] === 'pendiente'   ? 'selected' : '' ?>>Pendiente</option>
                <option value="confirmada"  <?= $cita['estado'] === 'confirmada'  ? 'selected' : '' ?>>Confirmada</option>
                <option value="atendida"    <?= $cita['estado'] === 'atendida'    ? 'selected' : '' ?>>Atendida</option>
                <option value="cancelada"   <?= $cita['estado'] === 'cancelada'   ? 'selected' : '' ?>>Cancelada</option>
                <option value="no_asistio"  <?= $cita['estado'] === 'no_asistio'  ? 'selected' : '' ?>>No Asistió</option>
            </select>
        </div>

        <!-- Notas -->
        <div class="col-12">
            <label class="form-label fw-medium">Notas / Observaciones</label>
            <textarea name="notas" class="form-control" rows="2"><?= clean($cita['notas'] ?? '') ?></textarea>
        </div>

        <div class="col-12 d-flex gap-2 justify-content-end mt-2">
            <a href="<?= BASE_URL ?>/agenda" class="btn btn-outline-secondary">Cancelar</a>
            <button type="submit" class="btn btn-primary px-4">
                <i class="bi bi-check-lg me-1"></i>Guardar Cambios
            </button>
        </div>
    </div>
</form>
</div>
</div>
</div>
</div>
