<?php /* Vista: Nueva Cita */ ?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h4 class="mb-0 fw-bold"><i class="bi bi-calendar-plus text-primary me-2"></i>Nueva Cita</h4>
    <a href="<?= BASE_URL ?>/agenda" class="btn btn-outline-secondary btn-sm">
        <i class="bi bi-arrow-left me-1"></i>Volver
    </a>
</div>

<div class="row justify-content-center">
<div class="col-lg-7">
<div class="card border-0 shadow-sm">
<div class="card-body p-4">
<form method="POST" action="<?= BASE_URL ?>/agenda">
    <?= csrf_field() ?>
    <div class="row g-3">

        <!-- Fecha y hora -->
        <div class="col-md-6">
            <label class="form-label fw-medium">Fecha <span class="text-danger">*</span></label>
            <input type="date" name="fecha" class="form-control"
                   value="<?= clean(post('fecha', $fecha ?? date('Y-m-d'))) ?>" required>
        </div>
        <div class="col-md-6">
            <label class="form-label fw-medium">Hora <span class="text-danger">*</span></label>
            <input type="time" name="hora" class="form-control"
                   value="<?= clean(post('hora', '09:00')) ?>" required>
        </div>

        <!-- Paciente -->
        <div class="col-12">
            <label class="form-label fw-medium">Nombre del Paciente <span class="text-danger">*</span></label>
            <input type="text" name="nombre_paciente" class="form-control" autofocus
                   value="<?= clean(post('nombre_paciente')) ?>"
                   placeholder="Nombre completo del paciente...">
            <div class="form-text">Ingresa el nombre del paciente para la cita.</div>
        </div>

        <!-- Teléfono -->
        <div class="col-md-6">
            <label class="form-label fw-medium">Teléfono de Contacto</label>
            <input type="text" name="telefono_paciente" class="form-control"
                   value="<?= clean(post('telefono_paciente')) ?>"
                   placeholder="+56 9 1234 5678">
        </div>

        <!-- Profesional -->
        <div class="col-md-6">
            <label class="form-label fw-medium">Profesional / Optómetra</label>
            <input type="text" name="profesional" class="form-control"
                   value="<?= clean(post('profesional')) ?>"
                   placeholder="Nombre del profesional...">
        </div>

        <!-- Motivo -->
        <div class="col-12">
            <label class="form-label fw-medium">Motivo de la Consulta</label>
            <input type="text" name="motivo" class="form-control"
                   value="<?= clean(post('motivo')) ?>"
                   placeholder="Ej: Control de vista, Adaptación de lentes de contacto...">
        </div>

        <!-- Duración -->
        <div class="col-md-4">
            <label class="form-label fw-medium">Duración (minutos)</label>
            <select name="duracion" class="form-select">
                <option value="15"  <?= post('duracion') === '15'  ? 'selected' : '' ?>>15 min</option>
                <option value="30"  <?= post('duracion', '30') === '30'  ? 'selected' : '' ?>>30 min</option>
                <option value="45"  <?= post('duracion') === '45'  ? 'selected' : '' ?>>45 min</option>
                <option value="60"  <?= post('duracion') === '60'  ? 'selected' : '' ?>>60 min</option>
                <option value="90"  <?= post('duracion') === '90'  ? 'selected' : '' ?>>90 min</option>
                <option value="120" <?= post('duracion') === '120' ? 'selected' : '' ?>>120 min</option>
            </select>
        </div>

        <!-- Estado inicial -->
        <div class="col-md-4">
            <label class="form-label fw-medium">Estado</label>
            <select name="estado" class="form-select">
                <option value="pendiente"  <?= post('estado', 'pendiente') === 'pendiente'  ? 'selected' : '' ?>>Pendiente</option>
                <option value="confirmada" <?= post('estado') === 'confirmada' ? 'selected' : '' ?>>Confirmada</option>
            </select>
        </div>

        <!-- Notas -->
        <div class="col-12">
            <label class="form-label fw-medium">Notas / Observaciones</label>
            <textarea name="notas" class="form-control" rows="2"
                      placeholder="Observaciones adicionales..."><?= clean(post('notas')) ?></textarea>
        </div>

        <div class="col-12 d-flex gap-2 justify-content-end mt-2">
            <a href="<?= BASE_URL ?>/agenda" class="btn btn-outline-secondary">Cancelar</a>
            <button type="submit" class="btn btn-primary px-4">
                <i class="bi bi-calendar-check me-1"></i>Agendar Cita
            </button>
        </div>
    </div>
</form>
</div>
</div>
</div>
</div>
