<?php
/**
 * OptiCore SaaS - FormaPago Model
 */

class FormaPago extends BaseModel
{
    protected string $table = 'formas_pago';

    public function getAll(int $page = 1, string $search = ''): array
    {
        $params = [$this->empresaScope()];
        $where  = 'empresa_id = ?';

        if ($search) {
            $where   .= ' AND nombre LIKE ?';
            $params[] = "%$search%";
        }

        $sql = "SELECT * FROM `{$this->table}` WHERE $where ORDER BY nombre ASC";
        return $this->db->paginate($sql, $params, $page);
    }

    public function getActivas(): array
    {
        return $this->db->fetchAll(
            "SELECT * FROM `{$this->table}` WHERE empresa_id = ? AND estado = 'activa' ORDER BY nombre",
            [$this->empresaScope()]
        );
    }

    public function getById(int $id): array|false
    {
        return $this->db->fetchOne(
            "SELECT * FROM `{$this->table}` WHERE id = ? AND empresa_id = ?",
            [$id, $this->empresaScope()]
        );
    }

    public function crear(array $data): int
    {
        return $this->db->insert($this->table, [
            'empresa_id' => $this->empresaScope(),
            'nombre'     => trim($data['nombre']),
            'tipo'       => $data['tipo'] ?? 'efectivo',
            'estado'     => $data['estado'] ?? 'activa',
        ]);
    }

    public function actualizar(int $id, array $data): int
    {
        return $this->update($id, [
            'nombre' => trim($data['nombre']),
            'tipo'   => $data['tipo'] ?? 'efectivo',
            'estado' => $data['estado'] ?? 'activa',
        ]);
    }

    public function eliminar(int $id): int
    {
        return $this->update($id, ['estado' => 'inactiva']);
    }

    public function tieneUso(int $id): bool
    {
        return (bool) $this->db->fetchColumn(
            "SELECT COUNT(*) FROM venta_pagos vp
             JOIN ventas v ON vp.venta_id = v.id
             WHERE vp.forma_pago_id = ? AND v.empresa_id = ?",
            [$id, $this->empresaScope()]
        );
    }
}
